/*********************************************************************
*
*                  PRINT.TTP
*                  =========
*
* modified by Claude Labelle
* based on PRINT.TTP released with MagiC, last change: 19.5.89,
* by Andreas Kromke
*
* Print program for printing TOS files 
*
*  Syntax: print [-p] file1...    - Prints file(s)
*	
*   
*          -p                     - No Form Feed after printing
*          
* This file is licensed according to GPLv3, see LICENSE file. 
*		 
*
*********************************************************************/

#include <portab.h>
#include <stdio.h>
#include <tos.h>
#include <string.h>
#include <ext.h>
#include <cookie.h>

#define TRUE   1
#define FALSE  0
#define EOS    '\0'
#define ESC    '\33'
#define FF     '\14'
#define CTRL_C '\3'
#define toupper(c)  (c & '\137')
#define TRANSFER_SIZE 64 
#define STATUS_BAR_LEN 36
#define MagX_COOKIE 0x4D616758L
#define MiNT_COOKIE 0x4D694E54L 

int  form_feed 	= TRUE;

int	print_file(char *dateiname);
void screen(char *string);
void toterm(void);
unsigned long get_file_size(char *fname, int domain);

void main(argc,argv)
int argc;
char *argv[];
{
	register int i;
	register char *parm;


     /* Check if started without parameters  */
	if (argc < 2) {
		message:
		screen("\r\nUsage: PRINT [-p] file1 file2 ...\r\n\r\n");
		screen("          -p    no form feed after each file\r\n\r\n");
		screen("Press any key.");
		Bconin(2);
		Pterm(1);
	}

	/* Evaluate all switches */
	for (i = 1; (i < argc+5) && (argv[i][0] == '-'); i++) {
		for	(parm = argv[i] + 1; *parm != EOS; parm++) {
			switch(toupper(*parm)) {
				case 'P' : 	form_feed    = FALSE;
				           	break;
				default  : 	screen("PRINT: Unknown switch: ");
						 	screen(argv[i]);
						 	screen("\r\n");
							screen("Press any key.");
							Bconin(2);
						 	Pterm(2);
			}
		}
	}

	/* Print files */
	if (i >= argc)				/* No files */
		goto message;
	for (; i < argc; i++) {
		if (print_file(argv[i])) {
			if (form_feed) {
				toterm();
				Cprnout(FF & 0xFF);
			}
		}
	}

	Pterm0();
}


/*********************************************************************
*
*  Prints the file named <filename> 
*  Return FALSE if error 
*
*********************************************************************/

int print_file(filename)
char filename[];
{
	long retcode;
	int handle;	
	long bytes_read;
	char buf[TRANSFER_SIZE];
	unsigned long file_length = 0L;
	char stat_block[] = "\33p \33q";
	long stat_bytes_read = 0L;
	long stat_block_size;
	int lfn = FALSE;					/* Supports long file names? */
	long val;
	
	if ((getcookie (MagX_COOKIE, &val) == TRUE) ||
		(getcookie (MiNT_COOKIE, &val) == TRUE))
	{
		/* Enable long filename support */
		Pdomain( 1 );
		lfn = TRUE;
	}

	retcode = Fopen(filename,0);
	if (retcode < 0L) {
		screen("PRINT: ");
		screen(filename);
		screen(" not found.\r\n");
		screen("Press any key.");
		Bconin(2);
		return(FALSE);
	}
	handle = (int) retcode;
	
	file_length = get_file_size(filename, lfn);
	if (file_length == 0) {
		screen("PRINT: Could not determine file size.\r\n");
		screen("Press any key.");
		Bconin(2);
		return(FALSE);
	}
	stat_block_size = file_length / STATUS_BAR_LEN;
	
	screen("Printing ");
	screen(filename);
	screen("...\r\n");
	screen("hold ESC to abort\r\n");
	screen("0........25.......50.......75.....100 %\r\n");
	screen(stat_block);
    
    while (bytes_read = Fread(handle, TRANSFER_SIZE, buf)) {
    	if (bytes_read < 0L) {
    		screen("\r\nError reading file, aborting.\r\n");
			screen("Press any key.");
			Bconin(2);    	
			return(FALSE);
    	}
    	toterm();
     	Fwrite(0xFFFD, bytes_read, buf);
     	stat_bytes_read += bytes_read;
     	
     	while (stat_bytes_read >= stat_block_size) {
     		screen(stat_block);
     		stat_bytes_read -= stat_block_size;   	
     	}
      	
     	/* Note, bconout much faster than Cprnout.
    	Reading 1 byte at a time much slower.
    	Fwrite as fast as bconout. */
    }
 	screen("\r\ndone.\r\n");

	Fclose(handle);
	return(TRUE);
}

/*********************************************************************
*
*  Write <string> on the screen
*
*********************************************************************/

void screen(string)
char *string;
{
	Fwrite(0xFFFF,(long) strlen(string), string);
}

/*********************************************************************
*
*  Reads keyboard buffer and asks if program should be aborted 
*
*********************************************************************/

void toterm()
{
	char c;

	do {
		if (Bconstat(2)) { /* When key is pressed */
			while(Bconstat(2)) {
				if (CTRL_C == (0xff & Bconin(2)))
					Pterm0();
				if (ESC == (0xff & Bconin(2))) {
					screen("Abort (y/n) ? ");
					do
						c = Bconin(2); 
					while (ESC == c);
					Bconout(5, c);
					if (toupper(c) == 'Y')
						Pterm0();
					screen("\r\n");		
				}		
			}
		}
	} while(!Cprnos());            /* as long as printer is not available */
}

unsigned long get_file_size(char *fname, int domain)
{
	struct stat buff;
	XATTR attributes;
	
	if (domain)
	{
		if (Fxattr(0, fname, &attributes) == 0)
			return attributes.size;
		else
			return 0UL;
	}
	else
	{
		if (stat(fname, &buff) == 0)
			return buff.st_size;
		else
			return 0UL;
	}
}
